<?php
/**
 * ----------------------------------------------------
 * Koneksi Database - PDO
 * Aplikasi Koperasi
 * ----------------------------------------------------
 */

$host     = "localhost";
$db_name  = "koperasi_db";
$username = "root";      // ganti sesuai server
$password = "";          // ganti sesuai server
$charset  = "utf8mb4";

try {
    $dsn = "mysql:host=$host;dbname=$db_name;charset=$charset";
    $options = [
        PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES   => false,
    ];

    $db = new PDO($dsn, $username, $password, $options);

} catch (PDOException $e) {
    // Simpan error ke log
    error_log(
        date('Y-m-d H:i:s') . " | DB ERROR: " . $e->getMessage() . PHP_EOL,
        3,
        __DIR__ . "/../logs/error.log"
    );

    // Tampilkan pesan umum (aman)
    die("Koneksi database gagal. Silakan hubungi administrator.");
}
